<?php 
session_start();
if (!isset($_SESSION['user'])) {
    header('location: login.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>SPK Weighted Product</title>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@latest/dist/style.css" rel="stylesheet" />
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/js/all.min.js" crossorigin="anonymous"></script>
    <style>

        #layoutSidenav.toggled #layoutSidenav_nav {
            width: 0 !important;
            overflow: hidden;
        }

        #layoutSidenav.toggled #layoutSidenav_content {
            margin-left: 0 !important;
            width: 100% !important;
        }

        /* Navbar Header */
        .navbar-header {
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgb(0, 0, 120);
            color: white;
            text-align: center;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1060;
            padding: 15px;
            min-height: 80px; /* Membuat header lebih tinggi */
        }

        .judul {
            flex-grow: 1;
            text-align: center;
            font-size: 1.5rem;
            font-weight: bold;
            max-width: 80%;
        }

        /* Tombol Hamburger */
        .hamburger-menu {
            position: absolute;
            left: 15px; /* Selalu di pojok kiri */
            top: 50%;
            transform: translateY(-50%); /* Biar tetap sejajar di tengah vertikal */
            background-color: rgb(255, 0, 0);
            color: white;
            border: none;
            font-size: 24px;
            padding: 10px 15px;
            border-radius: 5px;
            cursor: pointer;
            transition: 0.3s;
        }

        .hamburger-menu:hover {
            background-color: #343a40;
        }


        /* Mendorong halaman ke bawah */
        .spacer {
            margin-top: 100px; /* Ukuran disesuaikan dengan tinggi navbar */
        }

        @media (max-width: 1080px) {
            .judul {
                font-size: 1.3rem;
            }
        }

        @media (max-width: 768px) {
            .judul {
                font-size: 1.1rem;
            }
        }

        @media (max-width: 480px) {
            .judul {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body class="sb-nav-fixed">

    <!-- Navbar Header -->
    <div class="navbar-header">
        <button class="hamburger-menu" id="sidebarToggle">
            <i class="fas fa-bars"></i>
        </button>
        <div class="judul">
            SISTEM PENDUKUNG KEPUTUSAN EVALUASI EFEKTIVITAS PENGGUNAAN YOUTUBE SEBAGAI MEDIA PEMBELAJARAN MAHASISWA TEKNIK INFORMATIKA DENGAN METODE WEIGHTED PRODUCT
        </div>
    </div>

    <!-- Spacer untuk mendorong konten ke bawah -->
    <div class="spacer"></div>

    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading">🏠 Dashboard</div>
                        <a class="nav-link" href="index.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-home"></i></div>
                            Beranda
                        </a>
                        <div class="sb-sidenav-menu-heading">⚙️ Pengelolaan Data</div>
                        <a class="nav-link" href="bobot1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-weight-hanging"></i></div>
                            Kelola Bobot Kriteria
                        </a>
                        <a class="nav-link" href="mahasiswa.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-users"></i></div>
                            Kelola Data Mahasiswa (Alternatif)
                        </a>
                        <a class="nav-link" href="penilaian1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-clipboard-list"></i></div>
                            Kelola Penilaian Alternatif
                        </a>
                        <div class="sb-sidenav-menu-heading">⚖️ SPK Weighted Product</div>
                        <a class="nav-link" href="tampilandata1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-balance-scale"></i></div>
                            Bobot Kriteria & Nilai Alternatif
                        </a>
                        <a class="nav-link" href="analisis1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-search"></i></div>
                            Analisis Rata-rata
                        </a>
                        <a class="nav-link" href="proses1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-calculator"></i></div>
                            Proses Perhitungan
                        </a>
                        <a class="nav-link" href="hasilspk1.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-check"></i></div>
                            Hasil & Kesimpulan
                        </a>
                        <br><br>
                        <a class="nav-link" href="eng/index.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-globe"></i></div>
                            Ganti Bahasa (ENG)
                        </a>
                        <a class="nav-link" href="logout.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-sign-out-alt"></i></div>
                            Logout
                        </a>
                    </div>
                </div>
                <div class="sb-sidenav-footer">
                    <div class="small">Dibangun oleh:</div>
                    <div><strong>Muhammad Rizky Ramdhani, Ramdani Firmansyah, dan Dede Ruslan</strong></div>
                    <div class="small">Mahasiswa Universitas Nusa Putra Sukabumi</div>
                </div>
            </nav>
        </div>
    </div>

    <!-- JavaScript untuk Sidebar Toggle -->
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            let sidebarToggle = document.querySelector("#sidebarToggle");
            let layoutSidenav = document.querySelector("#layoutSidenav");
            let sidebar = document.querySelector("#layoutSidenav_nav");
            let content = document.querySelector("#layoutSidenav_content");

            // Periksa localStorage untuk status sidebar sebelumnya
            let isSidebarClosed = localStorage.getItem("sidebarClosed") === "true";

            // Pastikan layout menyesuaikan dari awal
            if (isSidebarClosed) {
                layoutSidenav.classList.add("toggled");
                content.style.marginLeft = "0";
                content.style.width = "100%";
            } else {
                content.style.marginLeft = "250px";
                content.style.width = "calc(100% - 250px)";
            }

            // Toggle sidebar ketika tombol diklik
            sidebarToggle.addEventListener("click", function () {
                layoutSidenav.classList.toggle("toggled");

                if (layoutSidenav.classList.contains("toggled")) {
                    content.style.marginLeft = "0";
                    content.style.width = "100%";
                    localStorage.setItem("sidebarClosed", "true");
                } else {
                    content.style.marginLeft = "250px";
                    content.style.width = "calc(100% - 250px)";
                    localStorage.setItem("sidebarClosed", "false");
                }
            });
        });
    </script>

</body>
</html>
